/*
 * Decompiled with CFR 0.152.
 */
package china.bilibili;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Main {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Correct usage: java -jar bilibili-fixer.jar <input> <output>");
            return;
        }
        Main.printWatermark();
        try {
            Main.loadJar(Path.of(args[0], new String[0]), Path.of(args[1], new String[0]), classNode -> {
                if (classNode.name.startsWith("rip/vantage")) {
                    return;
                }
                Main.fixCrashReporter(classNode);
                Main.fixLanguageCrashes(classNode);
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not rewrite jar file.", e);
        }
    }

    private static void fixCrashReporter(ClassNode classNode) {
        classNode.methods.forEach(method -> {
            InsnList insns = method.instructions;
            int count = 0;
            for (AbstractInsnNode insn : insns) {
                MethodInsnNode node;
                if (!(insn instanceof MethodInsnNode) || (node = (MethodInsnNode)insn).getOpcode() != 182 || (!node.owner.equals("java/lang/StackTraceElement") || !node.name.equals("isNativeMethod") || !node.desc.equals("()Z")) && (!node.owner.equals("java/lang/StackTraceElement") || !node.name.equals("getFileName") || !node.desc.equals("()Ljava/lang/String;"))) continue;
                ++count;
            }
            if (count < 4) {
                return;
            }
            insns.clear();
            insns.add(new InsnNode(3));
            insns.add(new InsnNode(172));
            System.out.println("[*] Fixed Crash Reporter (Class: " + classNode.name + ")");
        });
    }

    private static void fixLanguageCrashes(ClassNode classNode) {
        classNode.methods.forEach(method -> {
            InsnList insns = method.instructions;
            boolean found = false;
            AbstractInsnNode startInsn = null;
            AbstractInsnNode endInsn = null;
            MethodInsnNode callInsn = null;
            for (AbstractInsnNode insn : insns) {
                if (insn instanceof LdcInsnNode) {
                    String value;
                    LdcInsnNode ldc = (LdcInsnNode)insn;
                    Object patt0$temp = ldc.cst;
                    if (patt0$temp instanceof String && (value = (String)patt0$temp).equals("<percentsign>")) {
                        found = true;
                    }
                }
                if (!found || insn.getOpcode() != 182 || insn.getPrevious().getOpcode() != 182 || insn.getPrevious().getPrevious().getOpcode() != 182 || insn.getPrevious().getPrevious().getPrevious().getOpcode() != 25) continue;
                startInsn = insn.getPrevious().getPrevious().getPrevious().getPrevious().getPrevious();
                endInsn = insn;
                callInsn = (MethodInsnNode)insn.getPrevious().getPrevious();
            }
            if (!found) {
                return;
            }
            if (startInsn == null || endInsn == null || callInsn == null) {
                return;
            }
            LabelNode skipLabel = new LabelNode();
            InsnList ifList = new InsnList();
            ifList.add(new LabelNode());
            ifList.add(new VarInsnNode(25, 10));
            ifList.add(new MethodInsnNode(182, callInsn.owner, callInsn.name, callInsn.desc, false));
            ifList.add(new JumpInsnNode(198, skipLabel));
            insns.insertBefore(startInsn, ifList);
            insns.insertBefore(endInsn.getNext(), skipLabel);
            System.out.println("[*] Fixed Language Crash_0 (Class: " + classNode.name + ")");
        });
        classNode.methods.forEach(method -> {
            if (!method.desc.equals("(Ljava/lang/String;)I")) {
                return;
            }
            InsnList insns = method.instructions;
            int found = 0;
            AbstractInsnNode startInsn = null;
            AbstractInsnNode endInsn = null;
            for (AbstractInsnNode insn : insns) {
                String value;
                LdcInsnNode ldc;
                if (insn instanceof LdcInsnNode) {
                    ldc = (LdcInsnNode)insn;
                    Object patt0$temp = ldc.cst;
                    if (patt0$temp instanceof String && (value = (String)patt0$temp).equals("\u00a7l")) {
                        ++found;
                    }
                }
                if (insn instanceof LdcInsnNode) {
                    ldc = (LdcInsnNode)insn;
                    Object patt1$temp = ldc.cst;
                    if (patt1$temp instanceof String && (value = (String)patt1$temp).isEmpty()) {
                        ++found;
                    }
                }
                if (found != 2 || insn.getOpcode() != 54 || insn.getPrevious().getOpcode() != 139 || insn.getPrevious().getPrevious().getOpcode() != 98 || insn.getPrevious().getPrevious().getPrevious().getOpcode() != 102) continue;
                startInsn = insn.getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious().getPrevious();
                endInsn = insn;
            }
            if (found != 2) {
                return;
            }
            if (startInsn == null || endInsn == null) {
                return;
            }
            LabelNode skipLabel = new LabelNode();
            InsnList ifList = new InsnList();
            ifList.add(new LabelNode());
            ifList.add(new VarInsnNode(21, 7));
            ifList.add(new VarInsnNode(25, 2));
            ifList.add(new InsnNode(190));
            ifList.add(new JumpInsnNode(162, skipLabel));
            insns.insertBefore(startInsn, ifList);
            insns.insertBefore(endInsn.getNext(), skipLabel);
            System.out.println("[*] Fixed Language Crash_1 (Class: " + classNode.name + ")");
        });
    }

    private static void loadJar(Path path, Path output, Consumer<ClassNode> function) throws Exception {
        if (!Files.exists(path, new LinkOption[0])) {
            System.out.println("File " + String.valueOf(path) + " does not exist.");
            return;
        }
        System.out.println("[!] Input file: " + String.valueOf(path));
        System.out.println("[!] Output file: " + String.valueOf(output));
        if (Files.exists(output, new LinkOption[0])) {
            System.out.println("[!] File already exists, deleting: " + String.valueOf(output));
            Files.delete(output);
        }
        System.out.println("[!] Parsing input, this might take some time...");
        try (ZipFile zipFile = new ZipFile(path.toFile());
             ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(output.toFile()));){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
                newZipEntry.setTime(System.currentTimeMillis());
                zipOutputStream.putNextEntry(newZipEntry);
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".class")) {
                        ClassReader classReader = new ClassReader(inputStream);
                        ClassNode classNode = new ClassNode();
                        classReader.accept(classNode, 8);
                        function.accept(classNode);
                        ClassWriter classWriter = new ClassWriter(1);
                        classNode.accept(classWriter);
                        zipOutputStream.write(classWriter.toByteArray());
                    } else {
                        zipOutputStream.write(inputStream.readAllBytes());
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
    }

    private static void printWatermark() {
        System.out.println("  _____  _____  _____ ______   ______ _______   ________ _____  \n |  __ \\|_   _|/ ____|  ____| |  ____|_   _\\ \\ / /  ____|  __ \\ \n | |__) | | | | (___ | |__    | |__    | |  \\ V /| |__  | |__) |\n |  _  /  | |  \\___ \\|  __|   |  __|   | |   > < |  __| |  _  / \n | | \\ \\ _| |_ ____) | |____  | |     _| |_ / . \\| |____| | \\ \\ \n |_|  \\_\\_____|_____/|______| |_|    |_____/_/ \\_\\______|_|  \\_\\\n                         Version: v1.0.3                     \n");
    }
}

