package myau.management;

import myau.enums.FloatModules;
import myau.event.EventTarget;
import myau.events.PlayerUpdateEvent;
import net.minecraft.client.Minecraft;

import java.util.LinkedHashMap;

public class FloatManager {
    private static final Minecraft mc = Minecraft.getMinecraft();
    private final LinkedHashMap<FloatModules, Boolean> activeMap;
    private boolean floating;

    public FloatManager() {
        this.activeMap = new LinkedHashMap<>();
        this.floating = false;
    }

    public boolean isPredicted() {
        return this.floating;
    }

    public boolean isFalling() {
        return mc.thePlayer.onGround && mc.thePlayer.posY - mc.thePlayer.lastTickPosY < 0.0 && mc.thePlayer.motionY < 0.0;
    }

    public boolean hasActiveModule() {
        return this.activeMap.containsValue(true);
    }

    public void setFloatState(boolean boolean1, FloatModules mY) {
        this.activeMap.put(mY, boolean1);
    }

    @EventTarget
    public void onPlayerUpdate(PlayerUpdateEvent event) {
        if ((this.hasActiveModule() || this.isPredicted()) && this.isFalling()) {
            mc.thePlayer.setPosition(mc.thePlayer.posX, mc.thePlayer.posY + 0.001, mc.thePlayer.posZ);
            this.floating = true;
        } else {
            this.floating = false;
        }
    }
}
