package myau.command.commands;

import myau.Myau;
import myau.command.Command;
import myau.module.Module;
import myau.util.ChatUtil;
import myau.util.KeyBindUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class BindCommand extends Command {
    public BindCommand() {
        super(new ArrayList<>(Arrays.asList("bind", "b")));
    }

    @Override
    public void runCommand(ArrayList<String> args) {
        if (args.size() < 3) {
            if (args.size() == 2 && (args.get(1).equalsIgnoreCase("l") || args.get(1).equalsIgnoreCase("list"))) {
                List<Module> modules = Myau.moduleManager.modules.values().stream().filter(module -> module.getKey() != 0).collect(Collectors.toList());
                if (modules.isEmpty()) {
                    ChatUtil.sendFormatted(String.format("%sNo binds&r", Myau.clientName));
                } else {
                    ChatUtil.sendFormatted(String.format("%sBinds:&r", Myau.clientName));
                    for (Module module : modules) {
                        ChatUtil.sendFormatted(String.format("%s»&r %s&r", module.isHidden() ? "&8" : "&7", module.formatModule()));
                    }
                }
            } else {
                ChatUtil.sendFormatted(
                        String.format(
                                "%sUsage: .%s <&omodule&r> <&okey&r>&r | .%s &olist&r",
                                Myau.clientName,
                                args.get(0).toLowerCase(Locale.ROOT),
                                args.get(0).toLowerCase(Locale.ROOT)
                        )
                );
            }
        } else {
            int keyIndex = Keyboard.getKeyIndex(args.get(2).toUpperCase());
            if (keyIndex != 0) {
                int buttonIndex = Mouse.getButtonIndex(args.get(2).toUpperCase());
                if (buttonIndex != -1) {
                    keyIndex = buttonIndex - 100;
                }
                if (!args.get(1).equals("*")) {
                    Module module = Myau.moduleManager.getModule(args.get(1));
                    if (module == null) {
                        ChatUtil.sendFormatted(String.format("%sModule not found (&o%s&r)&r", Myau.clientName, args.get(1)));
                    } else {
                        module.setKey(keyIndex);
                        ChatUtil.sendFormatted(
                                String.format("%sBound &o%s&r to &l[%s]&r", Myau.clientName, module.getName(), KeyBindUtil.getKeyName(keyIndex))
                        );
                    }
                } else {
                    for (Module module : Myau.moduleManager.modules.values()) {
                        module.setKey(keyIndex);
                    }
                    ChatUtil.sendFormatted(
                            String.format("%sBound all modules to &l[%s]&r", Myau.clientName, KeyBindUtil.getKeyName(keyIndex))
                    );
                }
            }
        }
    }
}
