/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import wtf.tatp.meowtils.config.cfg;

public class TeamUtil {
    private static boolean spectator = false;
    private long spectatorTime = 0L;

    public static boolean inSpectator() {
        return spectator;
    }

    public static boolean ignoreSelf(String playerName) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && playerName != null && playerName.equalsIgnoreCase(mc.field_71439_g.func_70005_c_());
    }

    public static boolean ignoreTeam(String playerName) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayer target = mc.field_71441_e.field_73010_i.stream().filter(p -> p.func_70005_c_().equalsIgnoreCase(playerName)).findFirst().orElse(null);
        if (mc.field_71439_g == null || mc.field_71441_e == null || playerName == null) {
            return false;
        }
        if (!cfg.v.ignoreTeam) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (target.field_71075_bZ.field_75101_c) {
            return true;
        }
        try {
            if (mc.field_71439_g.func_142014_c((EntityLivingBase)target)) {
                return true;
            }
            String selfFormatted = mc.field_71439_g.func_145748_c_().func_150254_d();
            String targetFormatted = target.func_145748_c_().func_150254_d();
            String selfColor = TeamUtil.getMostFrequentColor(selfFormatted);
            String targetColor = TeamUtil.getMostFrequentColor(targetFormatted);
            if (selfColor != null && selfColor.equals(targetColor)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String getMostFrequentColor(String text) {
        if (text == null) {
            return null;
        }
        HashMap<String, Integer> colorCounts = new HashMap<String, Integer>();
        for (int i = 0; i < text.length() - 1; ++i) {
            char code;
            char c = text.charAt(i);
            if (c != '\u00a7' || ((code = text.charAt(i + 1)) < '0' || code > '9') && (code < 'a' || code > 'f')) continue;
            String currentColor = "\u00a7" + code;
            colorCounts.put(currentColor, colorCounts.getOrDefault(currentColor, 0) + 1);
        }
        return colorCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null || event.phase != TickEvent.Phase.END) {
            return;
        }
        long now = System.currentTimeMillis();
        if (mc.field_71439_g.field_71075_bZ.field_75101_c) {
            spectator = true;
            this.spectatorTime = now;
        } else {
            spectator = now - this.spectatorTime < 8000L;
        }
    }
}

