/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.modules.skywars;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.config.cfg;
import wtf.tatp.meowtils.gui.Module;
import wtf.tatp.meowtils.gui.values.BooleanValue;
import wtf.tatp.meowtils.util.GamemodeUtil;
import wtf.tatp.meowtils.util.NameUtil;
import wtf.tatp.meowtils.util.PlaySound;

public class EquipAlerts
extends Module {
    private BooleanValue sound;
    private BooleanValue helmet;
    private BooleanValue chestplate;
    private BooleanValue leggings;
    private BooleanValue boots;
    private static final Map<UUID, ItemStack[]> lastArmor = new HashMap<UUID, ItemStack[]>();

    public EquipAlerts() {
        super("EquipAlerts", "equipAlertsKey", "equipAlerts", Module.Category.Skywars);
        this.tooltip("Alerts when a player equips selected armor piece.");
        this.sound = new BooleanValue("Ping sound", "equipAlertsSound");
        this.addBoolean(this.sound);
        this.helmet = new BooleanValue("\u00a7bDiamond Helmet", "equipAlerts_helmet");
        this.addBoolean(this.helmet);
        this.chestplate = new BooleanValue("\u00a7bDiamond Chestplate", "equipAlerts_chestplate");
        this.addBoolean(this.chestplate);
        this.leggings = new BooleanValue("\u00a7bDiamond Leggings", "equipAlerts_leggings");
        this.addBoolean(this.leggings);
        this.boots = new BooleanValue("\u00a7bDiamond Boots", "equipAlerts_boots");
        this.addBoolean(this.boots);
    }

    @Override
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (!GamemodeUtil.skywarsGame) {
            return;
        }
        for (EntityPlayer player : mc.field_71441_e.field_73010_i) {
            if (player == mc.field_71439_g) continue;
            ItemStack[] currentArmor = (ItemStack[])player.field_71071_by.field_70460_b.clone();
            ItemStack[] previousArmor = lastArmor.get(player.func_110124_au());
            if (previousArmor != null) {
                for (int i = 0; i < currentArmor.length; ++i) {
                    String armorName;
                    ItemStack before = previousArmor[i];
                    ItemStack now = currentArmor[i];
                    if (ItemStack.func_77989_b((ItemStack)before, (ItemStack)now) || now == null || (armorName = this.allowedArmor(now.func_77973_b())) == null) continue;
                    Meowtils.addMessage(NameUtil.getTabDisplayName(player.func_70005_c_()) + EnumChatFormatting.GRAY + " equipped " + EnumChatFormatting.DARK_AQUA + armorName);
                    if (!cfg.v.equipAlertsSound) continue;
                    PlaySound.getInstance().playPingSoundMedium();
                }
            }
            lastArmor.put(player.func_110124_au(), currentArmor);
        }
    }

    private String allowedArmor(Item item) {
        if (item == Items.field_151161_ac && cfg.v.equipAlerts_helmet) {
            return "Diamond Helmet";
        }
        if (item == Items.field_151163_ad && cfg.v.equipAlerts_chestplate) {
            return "Diamond Chestplate";
        }
        if (item == Items.field_151173_ae && cfg.v.equipAlerts_leggings) {
            return "Diamond Leggings";
        }
        if (item == Items.field_151175_af && cfg.v.equipAlerts_boots) {
            return "Diamond Boots";
        }
        return null;
    }

    public static void clear() {
        lastArmor.clear();
    }
}

