/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.modules.render;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Timer;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.config.cfg;
import wtf.tatp.meowtils.gui.Module;
import wtf.tatp.meowtils.gui.values.BooleanValue;
import wtf.tatp.meowtils.gui.values.NumberValue;
import wtf.tatp.meowtils.modules.advanced.AntiBot;

public class HealthInfo
extends Module {
    private BooleanValue display;
    private NumberValue displayScale;
    private BooleanValue indicator;
    private NumberValue indicatorScale;
    private BooleanValue esp;
    private BooleanValue espWalls;
    private float indicatorHealth = 0.0f;
    private long lastIndicator = 0L;
    private String espMode = "Raven";
    private Field timerField;

    public HealthInfo() {
        super("HealthInfo", "healthInfoKey", "healthInfo", Module.Category.Render);
        this.tooltip("Displays various health information.");
        this.displayScale = new NumberValue("Display scale", 0.5, 1.5, 0.05, null, "healthInfoDisplayScale", Float.TYPE);
        this.addValue(this.displayScale);
        this.indicatorScale = new NumberValue("Indicator scale", 0.5, 5.0, 0.05, null, "healthInfoIndicatorScale", Float.TYPE);
        this.addValue(this.indicatorScale);
        this.display = new BooleanValue("Show own health", "healthInfoDisplay");
        this.addBoolean(this.display);
        this.indicator = new BooleanValue("Show damage indicators", "healthInfoIndicator");
        this.addBoolean(this.indicator);
        this.esp = new BooleanValue("Show healthbars", "healthESP");
        this.addBoolean(this.esp);
        this.espWalls = new BooleanValue("\u00a77^ Healthbar through walls", "healthESPThroughWalls");
        this.addBoolean(this.espWalls);
        this.initializeTimerField();
    }

    private void initializeTimerField() {
        if (this.timerField != null) {
            return;
        }
        try {
            this.timerField = Minecraft.class.getDeclaredField("field_71428_T");
            this.timerField.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (mc.field_71462_r != null) {
            return;
        }
        if (cfg.v.healthInfoDisplay) {
            String heart;
            int hearts = (int)mc.field_71439_g.func_110143_aJ();
            int absorptionHearts = (int)mc.field_71439_g.func_110139_bj();
            boolean isAbsorptionActive = mc.field_71439_g.func_70644_a(Potion.field_76444_x);
            int health = isAbsorptionActive ? hearts + absorptionHearts : hearts;
            float scale = cfg.v.healthInfoDisplayScale;
            String string = heart = health < 4 ? "\u2763" : "\u2764";
            EnumChatFormatting healthColor = health < 3 ? EnumChatFormatting.DARK_RED : (health < 6 ? EnumChatFormatting.RED : (health < 10 ? EnumChatFormatting.YELLOW : (health < 15 ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_GREEN)));
            EnumChatFormatting heartColor = isAbsorptionActive ? EnumChatFormatting.GOLD : EnumChatFormatting.RED;
            String text = healthColor + String.valueOf(health) + heartColor + heart;
            if (!cfg.v.smoothFont) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                mc.field_71466_p.func_175063_a(text, (float)cfg.v.healthInfoDisplay_x / scale, (float)cfg.v.healthInfoDisplay_y / scale, -1);
                GlStateManager.func_179121_F();
            } else {
                Meowtils.fontRenderer.drawScaledStringWithShadow(text, cfg.v.healthInfoDisplay_x, cfg.v.healthInfoDisplay_y, -1, scale * 10.0f);
            }
        }
        if (cfg.v.healthInfoIndicator && System.currentTimeMillis() - this.lastIndicator <= 2000L) {
            float scale = cfg.v.healthInfoIndicatorScale;
            EnumChatFormatting healthColor = this.indicatorHealth < 3.0f ? EnumChatFormatting.DARK_RED : (this.indicatorHealth < 6.0f ? EnumChatFormatting.RED : (this.indicatorHealth < 10.0f ? EnumChatFormatting.YELLOW : (this.indicatorHealth < 15.0f ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_GREEN)));
            String text = healthColor + String.valueOf(this.indicatorHealth) + " HP";
            if (!cfg.v.smoothFont) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                mc.field_71466_p.func_175063_a(text, (float)cfg.v.healthInfoIndicator_x / scale, (float)cfg.v.healthInfoIndicator_y / scale, -1);
                GlStateManager.func_179121_F();
            } else {
                Meowtils.fontRenderer.drawScaledStringWithShadow(text, cfg.v.healthInfoIndicator_x, cfg.v.healthInfoIndicator_y, -1, scale * 10.0f);
            }
        }
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!cfg.v.healthInfoIndicator) {
            return;
        }
        String msg = event.message.func_150260_c();
        Pattern pattern = Pattern.compile("is on ([0-9]+(?:\\.[0-9]+)?) HP!");
        Matcher matcher = pattern.matcher(msg);
        if (matcher.find() && !msg.contains(":")) {
            String indicatorString = matcher.group(1);
            this.indicatorHealth = Float.parseFloat(indicatorString);
            this.lastIndicator = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!this.isWorldReady()) {
            return;
        }
        if (!cfg.v.healthESP) {
            return;
        }
        for (EntityPlayer player : this.mc.field_71441_e.field_73010_i) {
            if (cfg.v.antiBot && AntiBot.isBot(player) || player == this.mc.field_71439_g || player.field_70725_aQ != 0) continue;
            this.renderHealthBar(player);
        }
    }

    private void renderHealthBar(EntityPlayer player) {
        int ravenBarColor;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)this.getRenderPartialTicks() - this.mc.func_175598_ae().field_78730_l;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)this.getRenderPartialTicks() - this.mc.func_175598_ae().field_78731_m;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)this.getRenderPartialTicks() - this.mc.func_175598_ae().field_78728_n;
        double healthRatio = player.func_110143_aJ() / player.func_110138_aP();
        int barHeight = (int)(74.0 * healthRatio);
        barHeight = Math.max(0, Math.min(barHeight, 74));
        int n = healthRatio < 0.3 ? Color.red.getRGB() : (healthRatio < 0.5 ? Color.orange.getRGB() : (ravenBarColor = healthRatio < 0.7 ? Color.yellow.getRGB() : Color.green.getRGB()));
        if (this.espMode.equals("Raven")) {
            boolean depthEnabled = GL11.glIsEnabled((int)2929);
            GlStateManager.func_179094_E();
            GL11.glTranslated((double)x, (double)(y - 0.2), (double)z);
            GL11.glRotatef((float)(-this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            if (cfg.v.healthESPThroughWalls) {
                GlStateManager.func_179097_i();
            }
            GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
            Gui.func_73734_a((int)21, (int)-1, (int)25, (int)75, (int)Color.black.getRGB());
            Gui.func_73734_a((int)22, (int)barHeight, (int)24, (int)74, (int)Color.darkGray.getRGB());
            Gui.func_73734_a((int)22, (int)0, (int)24, (int)barHeight, (int)ravenBarColor);
            if (depthEnabled) {
                GlStateManager.func_179126_j();
            } else {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179121_F();
        }
    }

    private float getRenderPartialTicks() {
        if (this.timerField == null) {
            this.initializeTimerField();
        }
        if (this.timerField != null) {
            try {
                Timer timer = (Timer)this.timerField.get(this.mc);
                return timer.field_74281_c;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return 0.0f;
    }

    private boolean isWorldReady() {
        return this.mc.field_71439_g != null && this.mc.field_71441_e != null;
    }
}

