/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.modules.bedwars;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.config.cfg;
import wtf.tatp.meowtils.gui.Module;
import wtf.tatp.meowtils.gui.values.ArrayValue;
import wtf.tatp.meowtils.gui.values.BooleanValue;
import wtf.tatp.meowtils.gui.values.NumberValue;
import wtf.tatp.meowtils.util.ColorUtil;
import wtf.tatp.meowtils.util.GamemodeUtil;
import wtf.tatp.meowtils.util.NameUtil;
import wtf.tatp.meowtils.util.NotifyUtil;
import wtf.tatp.meowtils.util.PlaySound;
import wtf.tatp.meowtils.util.StripFormattingCodes;
import wtf.tatp.meowtils.util.TeamUtil;

public class ItemAlerts
extends Module {
    private BooleanValue potions;
    private BooleanValue bows;
    private BooleanValue pickaxes;
    private BooleanValue mobs;
    private BooleanValue common;
    private BooleanValue important;
    private BooleanValue explosives;
    private BooleanValue rotation;
    private NumberValue cooldown;
    private ArrayValue soundMode;
    private ArrayValue distanceMode;
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final Map<String, Map<String, Long>> cooldowns = new HashMap<String, Map<String, Long>>();

    public ItemAlerts() {
        super("ItemAlerts", "itemAlertsKey", "itemAlerts", Module.Category.Bedwars);
        this.tooltip("Alerts in chat when a player holds a specific item.");
        this.soundMode = new ArrayValue("Ping sound", Arrays.asList("All", "Important", "None"), "itemAlertsSoundMode");
        this.addArray(this.soundMode);
        this.distanceMode = new ArrayValue("Distance", Arrays.asList("All", "Important", "None"), "itemAlertsDistanceMode");
        this.addArray(this.distanceMode);
        this.cooldown = new NumberValue("Cooldown", 1.0, 30.0, 1.0, "s", "itemAlertsCooldown", Integer.TYPE);
        this.addValue(this.cooldown);
        this.common = new BooleanValue("\u00a77Common Items", "itemAlerts_commonItems");
        this.addBoolean(this.common);
        this.important = new BooleanValue("\u00a7dImportant Items", "itemAlerts_importantItems");
        this.addBoolean(this.important);
        this.rotation = new BooleanValue("\u00a73Rotation Items", "itemAlerts_rotationItems");
        this.addBoolean(this.rotation);
        this.potions = new BooleanValue("\u00a7ePotions", "itemAlerts_potions");
        this.addBoolean(this.potions);
        this.pickaxes = new BooleanValue("\u00a7bPickaxes", "itemAlerts_pickaxes");
        this.addBoolean(this.pickaxes);
        this.explosives = new BooleanValue("\u00a7cExplosives", "itemAlerts_explosives");
        this.addBoolean(this.explosives);
        this.bows = new BooleanValue("\u00a76Bows", "itemAlerts_bows");
        this.addBoolean(this.bows);
        this.mobs = new BooleanValue("Mobs", "itemAlerts_mobs");
        this.addBoolean(this.mobs);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        if (!GamemodeUtil.bedwarsGame || GamemodeUtil.bedwarsLobby) {
            return;
        }
        for (EntityPlayer player : this.mc.field_71441_e.field_73010_i) {
            if (player == null || player == this.mc.field_71439_g || TeamUtil.ignoreTeam(player.func_70005_c_())) continue;
            if (TeamUtil.inSpectator()) {
                return;
            }
            ItemStack held = player.func_70694_bm();
            String itemName = null;
            if (held == null) continue;
            if (cfg.v.itemAlerts_commonItems) {
                if (held.func_77973_b() == Items.field_151040_l) {
                    itemName = EnumChatFormatting.WHITE + "Iron Sword";
                } else if (held.func_77973_b() == Items.field_151153_ao) {
                    itemName = EnumChatFormatting.GOLD + "Golden Apple";
                }
            }
            if (cfg.v.itemAlerts_importantItems) {
                if (held.func_77973_b() == Items.field_151048_u) {
                    itemName = EnumChatFormatting.AQUA + "Diamond Sword";
                } else if (held.func_77973_b() == Items.field_151055_y) {
                    itemName = EnumChatFormatting.GOLD + "Knockback Stick";
                } else if (held.func_77973_b() == Items.field_151131_as) {
                    itemName = EnumChatFormatting.BLUE + "Water Bucket";
                } else if (held.func_77973_b() == Items.field_151079_bi && !held.func_77962_s()) {
                    itemName = EnumChatFormatting.DARK_PURPLE + "Ender Pearl";
                } else if (held.func_77973_b() == Items.field_151110_aK) {
                    itemName = EnumChatFormatting.DARK_AQUA + "Bridge Egg";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
                    itemName = EnumChatFormatting.DARK_GRAY + "Obsidian";
                }
            }
            if (cfg.v.itemAlerts_potions) {
                if (held.func_77973_b() == Items.field_151117_aB) {
                    itemName = EnumChatFormatting.WHITE + "Milk";
                } else if (held.func_82833_r().toLowerCase().contains("jump")) {
                    itemName = EnumChatFormatting.GREEN + "Jump Potion";
                } else if (held.func_82833_r().toLowerCase().contains("speed")) {
                    itemName = EnumChatFormatting.YELLOW + "Speed Potion";
                } else if (held.func_82833_r().toLowerCase().contains("invis")) {
                    itemName = EnumChatFormatting.AQUA + "Invis Potion";
                }
            }
            if (cfg.v.itemAlerts_pickaxes) {
                if (held.func_77973_b() == Items.field_151046_w) {
                    itemName = EnumChatFormatting.AQUA + "Diamond Pickaxe";
                } else if (held.func_77973_b() == Items.field_151005_D) {
                    itemName = EnumChatFormatting.GOLD + "Golden Pickaxe";
                }
            }
            if (cfg.v.itemAlerts_explosives) {
                if (held.func_77973_b() == Items.field_151059_bz) {
                    itemName = EnumChatFormatting.RED + "Fireball";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W) && !held.func_77962_s()) {
                    itemName = EnumChatFormatting.RED + "T" + EnumChatFormatting.WHITE + "N" + EnumChatFormatting.RED + "T";
                }
            }
            if (cfg.v.itemAlerts_bows) {
                if (held.func_77973_b() == Items.field_151031_f && held.func_77962_s()) {
                    itemName = EnumChatFormatting.GOLD + "Enchanted Bow";
                } else if (held.func_77973_b() == Items.field_151031_f) {
                    itemName = EnumChatFormatting.GOLD + "Bow";
                }
            }
            if (cfg.v.itemAlerts_mobs) {
                if (held.func_77973_b() == Items.field_151126_ay && !held.func_77962_s()) {
                    itemName = EnumChatFormatting.WHITE + "Bedbug";
                } else if (held.func_77973_b() == Items.field_151063_bx && held.func_77960_j() != 93) {
                    itemName = EnumChatFormatting.WHITE + "Iron Golem";
                }
            }
            if (cfg.v.itemAlerts_rotationItems) {
                if (held.func_77973_b() == Items.field_151156_bN) {
                    itemName = EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.UNDERLINE + "Shuriken";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD) && held.func_77962_s()) {
                    itemName = EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.UNDERLINE + "Ice Bridge";
                } else if (held.func_77973_b() == Items.field_151145_ak) {
                    itemName = EnumChatFormatting.DARK_BLUE.toString() + EnumChatFormatting.UNDERLINE + "Bridge Zapper";
                } else if (held.func_77973_b() == Items.field_151136_bY) {
                    itemName = EnumChatFormatting.GOLD.toString() + EnumChatFormatting.UNDERLINE + "Charlie the Unicorn";
                } else if (held.func_77973_b() == Items.field_151079_bi && held.func_77962_s()) {
                    itemName = EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.UNDERLINE + "Time Warp Pearl";
                } else if (held.func_77973_b() == Items.field_151106_aX) {
                    itemName = EnumChatFormatting.AQUA.toString() + EnumChatFormatting.UNDERLINE + "Sugar Cookie";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150321_G)) {
                    itemName = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.UNDERLINE + "Cobweb";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
                    itemName = EnumChatFormatting.DARK_GREEN.toString() + EnumChatFormatting.UNDERLINE + "Teleportation Device";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W) && held.func_77962_s()) {
                    itemName = EnumChatFormatting.DARK_RED.toString() + EnumChatFormatting.UNDERLINE + "Mega " + EnumChatFormatting.RED + "T" + EnumChatFormatting.WHITE + "N" + EnumChatFormatting.RED + "T";
                } else if (held.func_77973_b() == Items.field_151051_r) {
                    itemName = EnumChatFormatting.GOLD.toString() + EnumChatFormatting.UNDERLINE + "Mace";
                } else if (held.func_77973_b() == Items.field_151126_ay && held.func_77962_s()) {
                    itemName = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.UNDERLINE + "Wind Charge";
                } else if (held.func_77973_b() == Items.field_151097_aZ && held.func_77962_s()) {
                    itemName = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.UNDERLINE + "Enchanted Shears";
                } else if (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150461_bJ) && !held.func_77962_s()) {
                    itemName = EnumChatFormatting.RED.toString() + EnumChatFormatting.UNDERLINE + "Final Revive Beacon";
                } else if (held.func_77973_b() == Items.field_179562_cC) {
                    itemName = EnumChatFormatting.AQUA.toString() + EnumChatFormatting.UNDERLINE + "Block Zapper";
                }
            }
            if (itemName == null || this.hasCooldown(player.func_70005_c_(), itemName)) continue;
            this.alert(player, itemName);
            this.setCooldown(player.func_70005_c_(), itemName);
        }
    }

    private void alert(EntityPlayer player, String itemName) {
        String showDistance;
        float distanceToEntity = player.func_70032_d((Entity)this.mc.field_71439_g);
        DecimalFormat df = new DecimalFormat("#");
        String distanceFormatted = df.format(distanceToEntity);
        String distance = EnumChatFormatting.GRAY + " (" + EnumChatFormatting.AQUA + distanceFormatted + "m" + EnumChatFormatting.GRAY + ")";
        String rawItemName = StripFormattingCodes.stripFormattingCodes(itemName).toLowerCase();
        String string = cfg.v.itemAlertsDistanceMode.equals("All") ? distance : (showDistance = cfg.v.itemAlertsDistanceMode.equals("Important") && (rawItemName.equalsIgnoreCase("fireball") || rawItemName.equalsIgnoreCase("ender pearl") || rawItemName.equalsIgnoreCase("bridge egg") || rawItemName.equalsIgnoreCase("speed potion") || rawItemName.equalsIgnoreCase("jump potion")) || rawItemName.equalsIgnoreCase("invis potion") || rawItemName.equalsIgnoreCase("charlie the unicorn") ? distance : "");
        if (!this.hasCooldown(player.func_70005_c_(), itemName)) {
            Meowtils.addMessage(NameUtil.getTabDisplayName(player.func_70005_c_()) + EnumChatFormatting.GRAY + " has " + itemName + showDistance);
            this.setCooldown(player.func_70005_c_(), itemName);
        }
        if (cfg.v.notify && cfg.v.notifyItemAlerts) {
            NotifyUtil.notifyParty(player.func_70005_c_() + " has " + ColorUtil.unformattedText(itemName));
        }
        if (cfg.v.itemAlertsSoundMode.equals("All")) {
            this.sound();
        } else if (cfg.v.itemAlertsSoundMode.equals("Important") && rawItemName.equalsIgnoreCase("jump potion") || rawItemName.equalsIgnoreCase("speed potion") || rawItemName.equalsIgnoreCase("invis potion") || rawItemName.equalsIgnoreCase("bridge egg") || rawItemName.equalsIgnoreCase("diamond sword") || rawItemName.equalsIgnoreCase("iron golem") || rawItemName.equalsIgnoreCase("bedbug") || rawItemName.equalsIgnoreCase("charlie the unicorn") || rawItemName.equalsIgnoreCase("diamond pickaxe") || rawItemName.equalsIgnoreCase("enchanted bow") || rawItemName.equalsIgnoreCase("milk") || rawItemName.equalsIgnoreCase("ender pearl")) {
            this.sound();
        }
    }

    private boolean hasCooldown(String playerName, String itemName) {
        long ALERT_COOLDOWN = (long)cfg.v.itemAlertsCooldown * 1000L;
        Map<String, Long> playerCooldowns = cooldowns.get(playerName);
        if (playerCooldowns == null) {
            return false;
        }
        Long lastTime = playerCooldowns.get(itemName);
        return lastTime != null && System.currentTimeMillis() - lastTime < ALERT_COOLDOWN;
    }

    private void setCooldown(String playerName, String itemName) {
        cooldowns.computeIfAbsent(playerName, k -> new HashMap()).put(itemName, System.currentTimeMillis());
    }

    private void sound() {
        PlaySound.getInstance().playPingSound();
    }

    public static void clear() {
        cooldowns.clear();
    }
}

