/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.modules.antisnipe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.config.cfg;
import wtf.tatp.meowtils.gui.Module;
import wtf.tatp.meowtils.gui.values.BooleanValue;
import wtf.tatp.meowtils.util.GamemodeUtil;
import wtf.tatp.meowtils.util.NameUtil;
import wtf.tatp.meowtils.util.PlaySound;
import wtf.tatp.meowtils.util.TeamUtil;

public class SniperWarning
extends Module {
    private BooleanValue sniperPingSound;
    private BooleanValue alertParty;
    private int tickCounter = 0;
    private static final Map<String, Boolean> notifiedPlayers = new HashMap<String, Boolean>();

    public SniperWarning() {
        super("SniperWarning", "sniperWarningKey", "sniperWarning", Module.Category.Antisnipe);
        this.tooltip("Warns you of potential snipers in your game.");
        this.sniperPingSound = new BooleanValue("Ping sound", "sniperWarningSound");
        this.addBoolean(this.sniperPingSound);
        this.alertParty = new BooleanValue("Alert party", "sniperWarningAlertParty");
        this.addBoolean(this.alertParty);
    }

    @Override
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!GamemodeUtil.bedwarsGame || GamemodeUtil.bedwarsLobby) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && this.mc.field_71441_e != null) {
            List playerList = this.mc.field_71441_e.field_73010_i;
            if (++this.tickCounter % 20 != 0) {
                return;
            }
            for (EntityPlayer player : playerList) {
                this.checkGear(player);
            }
        }
    }

    private void checkGear(EntityPlayer player) {
        ItemSword sword;
        ItemStack heldItem;
        if (player == null || player.field_71071_by == null) {
            return;
        }
        if (player == this.mc.field_71439_g) {
            return;
        }
        if (TeamUtil.ignoreTeam(player.func_70005_c_())) {
            return;
        }
        String name = player.func_70005_c_();
        if ((name.contains("mcalt_") || name.contains("mcalts_") || name.contains("hassalt_") || name.contains("dogalt_") || name.contains("mal_") || name.contains("bym_") || name.contains("jy6_") || name.contains("lf_") || name.contains("wg_") || name.contains("ggnekito") || name.contains("dahai_") || name.contains("tzi_") || name.contains("nicegen") || name.contains("opalalts") || name.contains("tzi") || name.contains("msmc")) && !notifiedPlayers.containsKey(name)) {
            this.notifyPlayer(name);
            notifiedPlayers.put(name, true);
            return;
        }
        boolean hasChain = false;
        boolean hasIronSword = false;
        for (ItemStack armor : player.field_71071_by.field_70460_b) {
            ItemArmor itemArmor;
            if (armor == null || !(armor.func_77973_b() instanceof ItemArmor) || (itemArmor = (ItemArmor)armor.func_77973_b()).func_82812_d() != ItemArmor.ArmorMaterial.CHAIN) continue;
            hasChain = true;
            break;
        }
        if ((heldItem = player.func_70694_bm()) != null && heldItem.func_77973_b() instanceof ItemSword && (sword = (ItemSword)heldItem.func_77973_b()).func_150932_j().equals("IRON")) {
            hasIronSword = true;
        }
        if (hasChain && hasIronSword && !notifiedPlayers.containsKey(player.func_70005_c_())) {
            this.notifyPlayer(player.func_70005_c_());
            notifiedPlayers.put(player.func_70005_c_(), true);
        }
    }

    private void notifyPlayer(String playerName) {
        String displayName = NameUtil.getTabDisplayName(playerName);
        String displayNameClean = this.getCleanTabDisplayName(playerName);
        if (!"NONE".equals(displayName)) {
            Meowtils.addMessage(EnumChatFormatting.RED + "Warning: " + displayName + EnumChatFormatting.GRAY + " might be a sniper!");
            if (cfg.v.sniperWarningSound) {
                PlaySound.getInstance().playPingSoundDeep();
            }
            if (cfg.v.sniperWarningAlertParty) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/pc [M] \u00bb Warning: " + displayNameClean + " might be a sniper!");
            }
        }
    }

    private boolean isPlayerInGame() {
        return this.mc.field_71439_g != null && this.mc.field_71441_e != null;
    }

    private String getCleanTabDisplayName(String playerName) {
        ScorePlayerTeam playerTeam = Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96509_i(playerName);
        if (playerTeam == null) {
            return "NONE";
        }
        String prefix = playerTeam.func_96668_e().replaceAll("\u00a7.", "");
        String suffix = playerTeam.func_96663_f().replaceAll("\u00a7.", "");
        return prefix + playerName + suffix;
    }

    public static void clear() {
        notifiedPlayers.clear();
    }
}

