/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.modules.advanced;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import wtf.tatp.meowtils.config.cfg;
import wtf.tatp.meowtils.gui.Module;
import wtf.tatp.meowtils.gui.values.ArrayValue;
import wtf.tatp.meowtils.gui.values.BooleanValue;
import wtf.tatp.meowtils.gui.values.NumberValue;
import wtf.tatp.meowtils.mixins.GuiContainerAccessor;
import wtf.tatp.meowtils.modules.skywars.ItemHighlight;

public class InventoryFill
extends Module {
    public static final Set<Integer> clickedSlots = new HashSet<Integer>();
    private long nextClickTime = 0L;
    private long nextAutoClickTime = 0L;
    private ArrayValue clickMode;
    private BooleanValue renderClicked;
    private NumberValue cps;
    private NumberValue autoDelay;
    private ArrayValue mode;

    public InventoryFill() {
        super("InventoryFill", "inventoryFillKey", "inventoryFill", Module.Category.Advanced);
        this.tooltip("Automatically clicks items in inventories for you.\n-Auto/Manual mode, grab items from chests automatically or manually\n\u00a7cWARNING: \u00a7cThis \u00a7cmight \u00a7cflag \u00a7con \u00a7clow \u00a7cdelay.");
        this.cps = new NumberValue("CPS", 1.0, 20.0, 1.0, null, "inventoryFillCps", Integer.TYPE);
        this.addValue(this.cps);
        this.autoDelay = new NumberValue("Auto delay", 50.0, 1000.0, 50.0, "ms", "inventoryFillAutoDelay", Integer.TYPE);
        this.addValue(this.autoDelay);
        this.renderClicked = new BooleanValue("Render clicked", "inventoryFillRenderClicked");
        this.addBoolean(this.renderClicked);
        this.clickMode = new ArrayValue("Click Mode", Arrays.asList("Left", "Drop", "Both"), "inventoryFillClickMode");
        this.addArray(this.clickMode);
        this.mode = new ArrayValue("Mode", Arrays.asList("Manual", "Auto"), "inventoryFillMode");
        this.addArray(this.mode);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        boolean allowDrop;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (mc.field_71439_g == null || mc.field_71462_r == null || mc.field_71442_b == null) {
            return;
        }
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return;
        }
        if (!mc.field_71442_b.func_178889_l().func_77144_e()) {
            return;
        }
        GuiContainer gui = (GuiContainer)mc.field_71462_r;
        Slot hovered = gui.getSlotUnderMouse();
        boolean shiftDown = Keyboard.isKeyDown((int)42);
        boolean leftClickDown = Mouse.isButtonDown((int)0);
        boolean dropKeyDown = Keyboard.isKeyDown((int)mc.field_71474_y.field_74316_C.func_151463_i());
        boolean ctrlKeyDown = Keyboard.isKeyDown((int)29);
        long now = System.currentTimeMillis();
        String clickMode = cfg.v.inventoryFillClickMode;
        boolean allowLeft = clickMode.equals("Left") || clickMode.equals("Both");
        boolean bl = allowDrop = clickMode.equals("Drop") || clickMode.equals("Both");
        if (cfg.v.inventoryFillRenderClicked) {
            clickedSlots.clear();
        }
        if (cfg.v.inventoryFillMode.equals("Auto") && allowLeft && leftClickDown && shiftDown && now >= this.nextAutoClickTime) {
            this.nextAutoClickTime = now + (long)cfg.v.inventoryFillAutoDelay;
            this.autoHandler(gui);
        }
        if (allowLeft && leftClickDown && shiftDown && now >= this.nextClickTime) {
            this.nextClickTime = now + 1000L / (long)cfg.v.inventoryFillCps;
            this.leftClickHandler(gui, hovered);
        }
        if (allowDrop && dropKeyDown && hovered != null && hovered.func_75216_d()) {
            this.dropHandler(gui, hovered, ctrlKeyDown);
        }
    }

    private void autoHandler(GuiContainer gui) {
        if (!(gui instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        IInventory lowerInventory = ((ContainerChest)guiChest.field_147002_h).func_85151_d();
        String inventoryName = lowerInventory.func_145748_c_().func_150260_c();
        String localizedChest = I18n.func_135052_a((String)"container.chest", (Object[])new Object[0]);
        String localizedLargeChest = I18n.func_135052_a((String)"container.chestDouble", (Object[])new Object[0]);
        if (!inventoryName.equals(localizedChest) && !inventoryName.equals(localizedLargeChest)) {
            return;
        }
        for (Slot chestSlot : gui.field_147002_h.field_75151_b) {
            ItemStack stack;
            if (chestSlot == null || !chestSlot.func_75216_d() || chestSlot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (stack = chestSlot.func_75211_c()) == null) continue;
            String id = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
            if (ItemHighlight.getItemBlacklist().contains(id)) continue;
            this.click(gui, chestSlot, 0, 1);
            break;
        }
    }

    private void leftClickHandler(GuiContainer gui, Slot hovered) {
        if (hovered == null || !hovered.func_75216_d()) {
            return;
        }
        this.click(gui, hovered, 0, 1);
    }

    private void dropHandler(GuiContainer gui, Slot hovered, boolean ctrlDown) {
        int type = 4;
        int button = ctrlDown ? 1 : 0;
        this.click(gui, hovered, button, type);
    }

    private void click(GuiContainer gui, Slot slot, int mouseButton, int type) {
        ((GuiContainerAccessor)gui).clickSlot(slot, slot.field_75222_d, mouseButton, type);
        if (cfg.v.inventoryFillRenderClicked) {
            clickedSlots.add(slot.field_75222_d);
        }
    }
}

