/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.util.MojangNameToUUID;
import wtf.tatp.meowtils.util.NameUtil;
import wtf.tatp.meowtils.util.SafelistUtil;

public class SafelistCommand
extends CommandBase {
    public String func_71517_b() {
        return "safelist";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("sl");
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            Meowtils.addMessage(EnumChatFormatting.RED + "Usage: /safelist <player>");
            return;
        }
        if (args[0].equalsIgnoreCase("info")) {
            if (args.length < 2) {
                Meowtils.addMessage(EnumChatFormatting.RED + "Usage: /safelist info <player>");
                return;
            }
            String playername = args[1];
            for (NetworkPlayerInfo netInfo : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
                if (!netInfo.func_178845_a().getName().equalsIgnoreCase(playername)) continue;
                String uuid = netInfo.func_178845_a().getId().toString();
                if (!SafelistUtil.isSafelisted(uuid)) break;
                Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is safelisted.");
                return;
            }
            new Thread(() -> {
                try {
                    MojangNameToUUID lookup = new MojangNameToUUID(playername);
                    String uuid = lookup.getUUID();
                    boolean safelisted = uuid != null && SafelistUtil.isSafelisted(uuid) || SafelistUtil.isSafelisted(playername);
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        if (safelisted) {
                            Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is already in the safelist!");
                        } else {
                            Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is not in the safelist.");
                        }
                    });
                }
                catch (IOException e) {
                    Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RED + "Error retrieving UUID"));
                }
            }).start();
            return;
        }
        String playername = args[0];
        for (NetworkPlayerInfo netInfo : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
            if (!netInfo.func_178845_a().getName().equalsIgnoreCase(playername)) continue;
            String uuid = netInfo.func_178845_a().getId().toString();
            if (SafelistUtil.isSafelisted(uuid)) {
                Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is already safelisted.");
                return;
            }
            SafelistUtil.addToSafelist(uuid);
            Meowtils.addMessage(EnumChatFormatting.GREEN + "Safelisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + ".");
            return;
        }
        new Thread(() -> {
            try {
                MojangNameToUUID lookup = new MojangNameToUUID(playername);
                String uuid = lookup.getUUID();
                Minecraft.func_71410_x().func_152344_a(() -> {
                    if (uuid != null) {
                        if (SafelistUtil.isSafelisted(uuid)) {
                            Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is already safelisted.");
                        } else {
                            SafelistUtil.addToSafelist(uuid);
                            Meowtils.addMessage(EnumChatFormatting.GREEN + "Safelisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + ".");
                        }
                    } else if (SafelistUtil.isSafelisted(playername)) {
                        Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is already safelisted.");
                    } else {
                        SafelistUtil.addToSafelist(playername);
                        Meowtils.addMessage(EnumChatFormatting.GREEN + "Safelisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " by name.");
                    }
                });
            }
            catch (IOException e) {
                Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RED + "Error retrieving UUID"));
            }
        }).start();
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (NetworkPlayerInfo info : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
                names.add(info.func_178845_a().getName());
            }
            return SafelistCommand.func_175762_a((String[])args, names);
        }
        return null;
    }

    public int func_82362_a() {
        return 0;
    }
}

