/*
 * Decompiled with CFR 0.152.
 */
package wtf.tatp.meowtils.commands;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import wtf.tatp.meowtils.Meowtils;
import wtf.tatp.meowtils.util.BlacklistUtil;
import wtf.tatp.meowtils.util.MojangNameToUUID;
import wtf.tatp.meowtils.util.NameUtil;

public class BlacklistCommand
extends CommandBase {
    public String func_71517_b() {
        return "blacklist";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("bl");
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            Meowtils.addMessage(EnumChatFormatting.RED + "Usage: /blacklist <player> <reason>");
            return;
        }
        if (args[0].equalsIgnoreCase("info")) {
            if (args.length < 2) {
                Meowtils.addMessage(EnumChatFormatting.RED + "Usage: /blacklist info <player>");
                return;
            }
            String playername = args[1];
            for (NetworkPlayerInfo netInfo : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
                if (!netInfo.func_178845_a().getName().equalsIgnoreCase(playername)) continue;
                String uuid = netInfo.func_178845_a().getId().toString();
                if (!BlacklistUtil.isBlacklistedByUUID(uuid)) break;
                String entry = BlacklistUtil.getEntry(uuid);
                this.sendBlacklistInfo(sender, playername, entry);
                return;
            }
            new Thread(() -> {
                try {
                    MojangNameToUUID lookup = new MojangNameToUUID(playername);
                    String uuid = lookup.getUUID();
                    if (uuid != null && BlacklistUtil.isBlacklistedByUUID(uuid)) {
                        String entry = BlacklistUtil.getEntry(uuid);
                        Minecraft.func_71410_x().func_152344_a(() -> this.sendBlacklistInfo(sender, playername, entry));
                    } else if (BlacklistUtil.isBlacklisted(playername)) {
                        String entry = BlacklistUtil.getEntry(playername);
                        Minecraft.func_71410_x().func_152344_a(() -> this.sendBlacklistInfo(sender, playername, entry));
                    } else {
                        Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is not in the blacklist."));
                    }
                }
                catch (IOException e) {
                    Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RED + "Error retrieving UUID"));
                }
            }).start();
            return;
        }
        String playername = args[0];
        String reason = args.length > 1 ? this.reasonPreserve(Arrays.copyOfRange(args, 1, args.length)) : "cheating";
        for (NetworkPlayerInfo netInfo : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
            if (!netInfo.func_178845_a().getName().equalsIgnoreCase(playername)) continue;
            String uuid = netInfo.func_178845_a().getId().toString();
            if (BlacklistUtil.isBlacklistedByUUID(uuid)) {
                Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is already in the blacklist!");
                return;
            }
            BlacklistUtil.addToBlacklist(uuid, reason);
            Meowtils.addMessage(EnumChatFormatting.GREEN + "Blacklisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " for: " + BlacklistUtil.getFormattedReason(reason));
            return;
        }
        new Thread(() -> {
            try {
                MojangNameToUUID lookup = new MojangNameToUUID(playername);
                String uuid = lookup.getUUID();
                if (uuid != null) {
                    if (BlacklistUtil.isBlacklistedByUUID(uuid)) {
                        Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is already in the blacklist!"));
                    } else {
                        BlacklistUtil.addToBlacklist(uuid, reason);
                        Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.GREEN + "Blacklisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " for: " + BlacklistUtil.getFormattedReason(reason)));
                    }
                } else if (BlacklistUtil.isBlacklisted(playername)) {
                    Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is already in the blacklist!"));
                } else {
                    BlacklistUtil.addToBlacklist(playername, reason);
                    Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.GREEN + "Blacklisted " + EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " by name for: " + BlacklistUtil.getFormattedReason(reason)));
                }
            }
            catch (IOException e) {
                Minecraft.func_71410_x().func_152343_a(() -> Meowtils.addMessage(EnumChatFormatting.RED + "Error retrieving UUID"));
            }
        }).start();
    }

    private void sendBlacklistInfo(ICommandSender sender, String playername, String entry) {
        long timeMillis;
        if (entry == null) {
            Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.GREEN + " is not in the blacklist.");
            return;
        }
        String[] split = entry.split(" ", 2);
        String timestamp = split[0];
        String reason = split.length > 1 ? split[1] : "No reason provided";
        try {
            timeMillis = Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is blacklisted (couldn't find timestamp) for: " + BlacklistUtil.getFormattedReason(reason));
            return;
        }
        String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeMillis));
        Meowtils.addMessage(EnumChatFormatting.RESET + NameUtil.getTabDisplayName(playername) + EnumChatFormatting.RED + " is blacklisted since " + EnumChatFormatting.GRAY + formattedTime + EnumChatFormatting.RED + " for: " + BlacklistUtil.getFormattedReason(reason));
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (NetworkPlayerInfo info : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
                names.add(info.func_178845_a().getName());
            }
            return BlacklistCommand.func_175762_a((String[])args, names);
        }
        return null;
    }

    public int func_82362_a() {
        return 0;
    }

    private String reasonPreserve(String[] reasonParts) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < reasonParts.length; ++i) {
            String combined;
            String current = reasonParts[i].toLowerCase();
            if (i < reasonParts.length - 1 && (BlacklistUtil.NON_BLATANT.contains(combined = current + " " + reasonParts[i + 1].toLowerCase()) || BlacklistUtil.BLATANT.contains(combined))) {
                result.add(combined);
                ++i;
                continue;
            }
            result.add(current);
        }
        return String.join((CharSequence)" | ", result);
    }
}

